<?php
include_once("layout/header.php");
require_once("include/userClass.php");
require_once("include/loginFunction.php");

if (@$_SESSION['acct_no']) {
    header("Location:./user/dashboard.php");
}

if (isset($_POST['send-link'])) {
    $email = inputValidation($_POST['email']);
    $log = "SELECT * FROM users WHERE acct_email =:email";
    $stmt = $conn->prepare($log);
    $stmt->execute([
        'email' => $email
    ]);

    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    $validAcct_email = filter_var($email, FILTER_SANITIZE_EMAIL);

    if (!filter_var($validAcct_email, FILTER_VALIDATE_EMAIL)) {
        toast_alert("error", "Invalid email address please type a valid email address!");
    } elseif ($user['acct_email'] == "") {
        toast_alert("error", "No user is registered with this email address!");
    } else {

        $reset_token = bin2hex(random_bytes(16));
        date_default_timezone_set('Asia/kolkata');
        $date = date("Y-m-d");

        $sql = "UPDATE users SET resettoken=:reset_token,resettokenexp=:date WHERE acct_email=:email";
        $addUp = $conn->prepare($sql);
        $addUp->execute([
            'reset_token' => $reset_token,
            'date' => $date,
            'email' => $email
        ]);

        if (true) {
            if ($page['twillio_status'] == '1') {
                $number = $user['acct_phone'];
                $messageText = "Alert: Password Reset";
                $sendSms->sendSmsCode($number, $messageText);
            }
            
            // if ($page['padiwise_sms'] == '1') {
            //     $messageText = "Alert: Password Reset";
            //     $recipient = $user['acct_phone'];

            //     $responseBody = send_bulk_sms(array(
            //         'sender_name'=>get_setting('display_name'),
            //         'recipient'=>$recipient,
            //         'reference'=>date('Y').uniqid().rand(1,9),
            //         'message'=>$messageText
            //     ));
            // }

            $full_name = $user['firstname'] . " " . $user['lastname'];
            $APP_NAME = WEB_TITLE;
            $APP_URL = WEB_URL;
            $user_email = $user['acct_email'];
            $user_acctno = $user['acct_no'];
            $message = $sendMail->ForgotMsg($full_name, $email, $user_acctno, $reset_token, $APP_NAME, $APP_URL);
            // User Email
            $subject = "Password Reset" . "-" . $APP_NAME;
            $email_message->send_mail($user_email, $message, $subject);

            toast_alert("success", "Password reset link sent to email", "Thanks!");
        } else {
            toast_alert("error", "Sorry Something Went Wrong !");
        }
    }
}



?>

<div class="form-container outer">
    <div class="form-form">
        <div class="form-form-wrap">
            <div class="form-container">
                <div class="form-content">

                    <h1 class="">Sign In</h1>
                   
                    <p class="">Please type in the email address linked to your <?=$page['url_name']?> account to reset your password.</p>
                 <!--   <img src="./assets/settings/<?=$page['image']?>" class="navbar-logo" alt="logo" width="20%"> -->

                    <form class="text-left" method="POST">
                        <div class="form">

                            <div id="username-field" class="field-wrapper input">
                                 <div class="d-flex justify-content-between">
                                    <label for="password">Email Address</label>
                                    <a href="./login.php" class="forgot-pass-link">Goto Login</a>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                         <input type="email" maxlength="60" class="form-control" placeholder="example@gmail.com" name="email" />
                            </div>

                            
                            <div class="d-sm-flex justify-content-between">
                                <div class="field-wrapper">
                                    <button type="submit" class="btn btn-primary" name="send-link" value="">Send Reset Link</button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<?php

include_once("layout/footer.php");

?>

